USE ETLConfig
GO





INSERT biml.ColumnTransformation (TransformationDescription, TransformationExpression)
VALUES ('Uppercase', 'UPPER(<<COL>>)')
	, ('Lowercase', 'LOWER(<<COL>>)')
	, ('Trim', 'TRIM(<<COL>>)')


GO




INSERT biml.TableLoadColumnTransformation
SELECT ct.ColumnTransformationID, tlc.TableLoadColumnID
FROM biml.ColumnTransformation ct
INNER JOIN biml.TableLoadColumn tlc
	ON ct.TransformationDescription = 'Lowercase'
	AND tlc.SourceColumnName IN ('Color')
UNION ALL
SELECT ct.ColumnTransformationID, tlc.TableLoadColumnID
FROM biml.ColumnTransformation ct
INNER JOIN biml.TableLoadColumn tlc
	ON ct.TransformationDescription = 'Uppercase'
	AND tlc.SourceColumnName IN ('Name')